<?php
/**
 * Widok Dashboard
 *
 * @package BossOfToys_Manager
 */

defined('ABSPATH') || exit;

$api = BOT()->api;
$settings = get_option('bot_settings', array());
$is_configured = $api->is_configured();

// Pobierz status jeśli skonfigurowane
$status = null;
$modules = array();
if ($is_configured) {
    $status = $api->get_status();
    $modules_response = $api->get_modules_list();
    if (!is_wp_error($modules_response) && isset($modules_response['modules'])) {
        $modules = $modules_response['modules'];
    }
}
?>

<div class="wrap bot-wrap">
    <h1 class="bot-title">
        <span class="dashicons dashicons-update"></span>
        <?php _e('BossOfToys Manager', 'bossoftoys-manager'); ?>
    </h1>

    <?php if (!$is_configured): ?>
        <!-- Komunikat o braku konfiguracji -->
        <div class="bot-notice bot-notice-warning">
            <p>
                <strong><?php _e('API nie jest skonfigurowane', 'bossoftoys-manager'); ?></strong><br>
                <?php _e('Przejdź do', 'bossoftoys-manager'); ?>
                <a href="<?php echo admin_url('admin.php?page=bossoftoys-settings'); ?>">
                    <?php _e('Ustawień', 'bossoftoys-manager'); ?>
                </a>
                <?php _e('i wprowadź URL oraz klucz API.', 'bossoftoys-manager'); ?>
            </p>
        </div>
    <?php else: ?>

        <!-- Status połączenia -->
        <div class="bot-status-bar" id="bot-status-bar">
            <div class="bot-status-indicator">
                <span class="bot-status-dot" id="bot-status-dot"></span>
                <span id="bot-status-text"><?php _e('Łączenie...', 'bossoftoys-manager'); ?></span>
            </div>
            <div class="bot-queue-info">
                <span><?php _e('Kolejka:', 'bossoftoys-manager'); ?></span>
                <strong id="bot-queue-count">-</strong>
            </div>
        </div>

        <!-- Moduły -->
        <div class="bot-modules-grid">
            <?php
            $module_icons = array(
                'stock-sync' => 'dashicons-database',
                'product-adder' => 'dashicons-plus-alt',
                'product-deleter' => 'dashicons-trash',
                'price-updater' => 'dashicons-tag',
                'order-forwarder' => 'dashicons-migrate',
                'description-generator' => 'dashicons-edit-large',
            );

            $module_names_pl = array(
                'stock-sync' => 'Synchronizacja stanów',
                'product-adder' => 'Dodawanie produktów',
                'product-deleter' => 'Usuwanie produktów',
                'price-updater' => 'Aktualizacja cen',
                'order-forwarder' => 'Przekazywanie zamówień',
                'description-generator' => 'Generator opisów AI',
            );

            foreach ($modules as $module):
                $id = $module['id'];
                $icon = $module_icons[$id] ?? 'dashicons-admin-generic';
                $name = $module_names_pl[$id] ?? $module['name'];
                $supports_dry_run = $module['supports_dry_run'] ?? false;
            ?>
                <div class="bot-module-card" data-module="<?php echo esc_attr($id); ?>">
                    <div class="bot-module-header">
                        <span class="dashicons <?php echo esc_attr($icon); ?>"></span>
                        <h3><?php echo esc_html($name); ?></h3>
                    </div>
                    <p class="bot-module-desc"><?php echo esc_html($module['description']); ?></p>
                    <div class="bot-module-footer">
                        <?php if ($supports_dry_run): ?>
                            <label class="bot-checkbox">
                                <input type="checkbox" class="bot-dry-run" checked>
                                <span><?php _e('DRY-RUN (test)', 'bossoftoys-manager'); ?></span>
                            </label>
                        <?php endif; ?>
                        <button class="button button-primary bot-run-btn" data-module="<?php echo esc_attr($id); ?>">
                            <span class="dashicons dashicons-controls-play"></span>
                            <?php _e('Uruchom', 'bossoftoys-manager'); ?>
                        </button>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>

        <!-- Aktywne zadanie -->
        <div class="bot-active-job" id="bot-active-job" style="display: none;">
            <div class="bot-job-header">
                <h2>
                    <span class="dashicons dashicons-clock"></span>
                    <?php _e('Aktywne zadanie', 'bossoftoys-manager'); ?>
                </h2>
                <button class="button bot-cancel-btn" id="bot-cancel-job">
                    <span class="dashicons dashicons-no"></span>
                    <?php _e('Anuluj', 'bossoftoys-manager'); ?>
                </button>
            </div>

            <div class="bot-job-info">
                <span class="bot-job-module" id="bot-job-module">-</span>
                <span class="bot-job-status" id="bot-job-status">-</span>
            </div>

            <div class="bot-progress-bar">
                <div class="bot-progress-fill" id="bot-progress-fill" style="width: 0%;"></div>
            </div>
            <div class="bot-progress-text" id="bot-progress-text">0%</div>

            <div class="bot-logs-container">
                <div class="bot-logs-header">
                    <h3><?php _e('Logi', 'bossoftoys-manager'); ?></h3>
                    <button class="button bot-logs-clear" id="bot-clear-logs">
                        <span class="dashicons dashicons-dismiss"></span>
                    </button>
                </div>
                <div class="bot-logs" id="bot-logs">
                    <!-- Logi będą tu dodawane przez JS -->
                </div>
            </div>
        </div>

        <!-- Historia zadań -->
        <div class="bot-history">
            <h2>
                <span class="dashicons dashicons-backup"></span>
                <?php _e('Ostatnie zadania', 'bossoftoys-manager'); ?>
            </h2>
            <table class="wp-list-table widefat fixed striped" id="bot-history-table">
                <thead>
                    <tr>
                        <th><?php _e('ID', 'bossoftoys-manager'); ?></th>
                        <th><?php _e('Moduł', 'bossoftoys-manager'); ?></th>
                        <th><?php _e('Status', 'bossoftoys-manager'); ?></th>
                        <th><?php _e('Data', 'bossoftoys-manager'); ?></th>
                        <th><?php _e('Podsumowanie', 'bossoftoys-manager'); ?></th>
                    </tr>
                </thead>
                <tbody id="bot-history-body">
                    <tr>
                        <td colspan="5" class="bot-loading">
                            <?php _e('Ładowanie...', 'bossoftoys-manager'); ?>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>

    <?php endif; ?>
</div>
