<?php
/**
 * Widok Harmonogram
 *
 * @package BossOfToys_Manager
 */

defined('ABSPATH') || exit;

$api = BOT()->api;
$schedule = get_option('bot_schedule', array());

// Dostępne interwały
$intervals = array(
    'every_5_minutes'  => __('Co 5 minut', 'bossoftoys-manager'),
    'every_15_minutes' => __('Co 15 minut', 'bossoftoys-manager'),
    'every_30_minutes' => __('Co 30 minut', 'bossoftoys-manager'),
    'hourly'           => __('Co godzinę', 'bossoftoys-manager'),
    'twicedaily'       => __('Dwa razy dziennie', 'bossoftoys-manager'),
    'daily'            => __('Raz dziennie', 'bossoftoys-manager'),
);

// Moduły do harmonogramu
$scheduled_modules = array(
    'stock_sync' => array(
        'name' => __('Synchronizacja stanów', 'bossoftoys-manager'),
        'icon' => 'dashicons-database',
        'desc' => __('Aktualizacja stanów magazynowych z BossOfToys', 'bossoftoys-manager'),
    ),
    'price_updater' => array(
        'name' => __('Aktualizacja cen', 'bossoftoys-manager'),
        'icon' => 'dashicons-tag',
        'desc' => __('Aktualizacja cen produktów na podstawie cennika', 'bossoftoys-manager'),
    ),
    'order_forwarder' => array(
        'name' => __('Przekazywanie zamówień', 'bossoftoys-manager'),
        'icon' => 'dashicons-migrate',
        'desc' => __('Automatyczne przekazywanie nowych zamówień do hurtowni', 'bossoftoys-manager'),
    ),
);
?>

<div class="wrap bot-wrap">
    <h1 class="bot-title">
        <span class="dashicons dashicons-calendar-alt"></span>
        <?php _e('Harmonogram', 'bossoftoys-manager'); ?>
    </h1>

    <?php if (!$api->is_configured()): ?>
        <div class="bot-notice bot-notice-warning">
            <p>
                <?php _e('Najpierw skonfiguruj połączenie z API w', 'bossoftoys-manager'); ?>
                <a href="<?php echo admin_url('admin.php?page=bossoftoys-settings'); ?>">
                    <?php _e('Ustawieniach', 'bossoftoys-manager'); ?>
                </a>.
            </p>
        </div>
    <?php else: ?>

        <div class="bot-schedule-info">
            <span class="dashicons dashicons-info-outline"></span>
            <p>
                <?php _e('Włącz automatyczne uruchamianie modułów według harmonogramu.', 'bossoftoys-manager'); ?>
                <?php _e('Zadania są uruchamiane przez WP-Cron.', 'bossoftoys-manager'); ?>
            </p>
        </div>

        <form id="bot-schedule-form">
            <div class="bot-schedule-grid">
                <?php foreach ($scheduled_modules as $module_key => $module): ?>
                    <?php
                    $config = $schedule[$module_key] ?? array('enabled' => false, 'interval' => 'daily');
                    $is_enabled = $config['enabled'] ?? false;
                    $current_interval = $config['interval'] ?? 'daily';

                    // Następne uruchomienie
                    $next_run = wp_next_scheduled('bot_cron_' . $module_key);
                    ?>
                    <div class="bot-schedule-card <?php echo $is_enabled ? 'bot-enabled' : ''; ?>">
                        <div class="bot-schedule-header">
                            <label class="bot-switch">
                                <input type="checkbox"
                                       name="schedule[<?php echo esc_attr($module_key); ?>][enabled]"
                                       value="1"
                                       <?php checked($is_enabled); ?>>
                                <span class="bot-slider"></span>
                            </label>
                            <div class="bot-schedule-title">
                                <span class="dashicons <?php echo esc_attr($module['icon']); ?>"></span>
                                <h3><?php echo esc_html($module['name']); ?></h3>
                            </div>
                        </div>

                        <p class="bot-schedule-desc"><?php echo esc_html($module['desc']); ?></p>

                        <div class="bot-schedule-options">
                            <label for="interval-<?php echo esc_attr($module_key); ?>">
                                <?php _e('Interwał:', 'bossoftoys-manager'); ?>
                            </label>
                            <select name="schedule[<?php echo esc_attr($module_key); ?>][interval]"
                                    id="interval-<?php echo esc_attr($module_key); ?>"
                                    class="bot-interval-select">
                                <?php foreach ($intervals as $value => $label): ?>
                                    <option value="<?php echo esc_attr($value); ?>"
                                            <?php selected($current_interval, $value); ?>>
                                        <?php echo esc_html($label); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <?php if ($next_run): ?>
                            <div class="bot-next-run">
                                <span class="dashicons dashicons-clock"></span>
                                <?php printf(
                                    __('Następne uruchomienie: %s', 'bossoftoys-manager'),
                                    date_i18n('Y-m-d H:i:s', $next_run)
                                ); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>

            <div class="bot-schedule-actions">
                <button type="submit" class="button button-primary">
                    <span class="dashicons dashicons-saved"></span>
                    <?php _e('Zapisz harmonogram', 'bossoftoys-manager'); ?>
                </button>
                <span class="spinner" id="bot-schedule-spinner"></span>
                <span class="bot-schedule-message" id="bot-schedule-message"></span>
            </div>
        </form>

        <div class="bot-cron-notice">
            <h3>
                <span class="dashicons dashicons-warning"></span>
                <?php _e('Ważne: Konfiguracja WP-Cron', 'bossoftoys-manager'); ?>
            </h3>
            <p>
                <?php _e('WordPress Cron działa przy odwiedzinach strony. Dla niezawodnego harmonogramu zalecamy ustawienie zewnętrznego crona:', 'bossoftoys-manager'); ?>
            </p>
            <code>*/5 * * * * curl -s "<?php echo esc_url(site_url('wp-cron.php?doing_wp_cron')); ?>" > /dev/null 2>&1</code>
            <p class="description">
                <?php _e('Dodaj tę linię do crontab na serwerze (crontab -e)', 'bossoftoys-manager'); ?>
            </p>
        </div>

    <?php endif; ?>
</div>
