<?php
/**
 * Widok Ustawienia
 *
 * @package BossOfToys_Manager
 */

defined('ABSPATH') || exit;

$settings = get_option('bot_settings', array());
$api_url = $settings['api_url'] ?? '';
$api_key = $settings['api_key'] ?? '';
$connected = $settings['connected'] ?? false;
$last_test = $settings['last_connection_test'] ?? null;
?>

<div class="wrap bot-wrap">
    <h1 class="bot-title">
        <span class="dashicons dashicons-admin-settings"></span>
        <?php _e('Ustawienia', 'bossoftoys-manager'); ?>
    </h1>

    <div class="bot-settings-container">
        <!-- Połączenie z API -->
        <div class="bot-settings-section">
            <h2>
                <span class="dashicons dashicons-admin-links"></span>
                <?php _e('Połączenie z API', 'bossoftoys-manager'); ?>
            </h2>

            <table class="form-table">
                <tr>
                    <th scope="row">
                        <label for="bot-api-url"><?php _e('URL serwera API', 'bossoftoys-manager'); ?></label>
                    </th>
                    <td>
                        <input type="url"
                               id="bot-api-url"
                               class="regular-text"
                               value="<?php echo esc_attr($api_url); ?>"
                               placeholder="http://twoj-vps:8000">
                        <p class="description">
                            <?php _e('Adres serwera Python API (np. http://192.168.1.100:8000)', 'bossoftoys-manager'); ?>
                        </p>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="bot-api-key"><?php _e('Klucz API', 'bossoftoys-manager'); ?></label>
                    </th>
                    <td>
                        <input type="password"
                               id="bot-api-key"
                               class="regular-text"
                               value="<?php echo esc_attr($api_key); ?>"
                               placeholder="Wklej klucz API">
                        <button type="button" class="button bot-toggle-password" data-target="bot-api-key">
                            <span class="dashicons dashicons-visibility"></span>
                        </button>
                        <p class="description">
                            <?php _e('64-znakowy klucz wygenerowany przy pierwszym uruchomieniu API', 'bossoftoys-manager'); ?>
                        </p>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?php _e('Status połączenia', 'bossoftoys-manager'); ?></th>
                    <td>
                        <div class="bot-connection-status">
                            <?php if ($connected): ?>
                                <span class="bot-status-badge bot-status-connected">
                                    <span class="dashicons dashicons-yes-alt"></span>
                                    <?php _e('Połączono', 'bossoftoys-manager'); ?>
                                </span>
                                <?php if ($last_test): ?>
                                    <span class="bot-last-test">
                                        <?php printf(__('Ostatni test: %s', 'bossoftoys-manager'), $last_test); ?>
                                    </span>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="bot-status-badge bot-status-disconnected">
                                    <span class="dashicons dashicons-warning"></span>
                                    <?php _e('Nie połączono', 'bossoftoys-manager'); ?>
                                </span>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
            </table>

            <div class="bot-settings-actions">
                <button type="button" class="button" id="bot-test-connection">
                    <span class="dashicons dashicons-update"></span>
                    <?php _e('Testuj połączenie', 'bossoftoys-manager'); ?>
                </button>
                <button type="button" class="button button-primary" id="bot-save-settings">
                    <span class="dashicons dashicons-saved"></span>
                    <?php _e('Zapisz ustawienia', 'bossoftoys-manager'); ?>
                </button>
                <span class="spinner" id="bot-settings-spinner"></span>
                <span class="bot-settings-message" id="bot-settings-message"></span>
            </div>
        </div>

        <!-- Instrukcje -->
        <div class="bot-settings-section bot-info-section">
            <h2>
                <span class="dashicons dashicons-info"></span>
                <?php _e('Instrukcje', 'bossoftoys-manager'); ?>
            </h2>

            <div class="bot-info-box">
                <h4><?php _e('Jak uzyskać URL i klucz API?', 'bossoftoys-manager'); ?></h4>
                <ol>
                    <li><?php _e('Na serwerze VPS przejdź do folderu z aplikacją', 'bossoftoys-manager'); ?></li>
                    <li><?php _e('Uruchom API:', 'bossoftoys-manager'); ?> <code>python run_api.py</code></li>
                    <li><?php _e('Przy pierwszym uruchomieniu zostanie wyświetlony klucz API - skopiuj go', 'bossoftoys-manager'); ?></li>
                    <li><?php _e('Wpisz adres IP/domenę VPS z portem 8000 jako URL', 'bossoftoys-manager'); ?></li>
                </ol>
            </div>

            <div class="bot-info-box">
                <h4><?php _e('Przykład konfiguracji', 'bossoftoys-manager'); ?></h4>
                <table class="bot-example-table">
                    <tr>
                        <td><strong>URL:</strong></td>
                        <td><code>http://123.45.67.89:8000</code></td>
                    </tr>
                    <tr>
                        <td><strong>Klucz:</strong></td>
                        <td><code>c7c3b506f5676db8cba60e7dfe...</code></td>
                    </tr>
                </table>
            </div>

            <div class="bot-info-box bot-warning-box">
                <h4>
                    <span class="dashicons dashicons-shield"></span>
                    <?php _e('Bezpieczeństwo', 'bossoftoys-manager'); ?>
                </h4>
                <p>
                    <?php _e('Zalecamy użycie HTTPS dla połączenia z API w środowisku produkcyjnym.', 'bossoftoys-manager'); ?>
                    <?php _e('Klucz API jest przechowywany bezpiecznie w bazie danych WordPress.', 'bossoftoys-manager'); ?>
                </p>
            </div>
        </div>
    </div>
</div>
